# returns string representation of the cross product vector to the vector parameters
# parameters are the components of the two vectors (x1 is x component of first vector, x2 is x component of second vector, etc.) */
def crossProduct(x1, y1, z1, x2, y2, z2):
    # components of cross product vector
    x = y1 * z2 - z1 * y2
    y = z1 * x2 - x1 * z2
    z = x1 * y2 - y1 * x2
    return "(" + str(x) + ", " + str(y) + ", " + str(z) + ")"

# returns dot product of vector parameters
# parameters are the components of the two vectors (x1 is x component of first vector, x2 is x component of second vector, etc.) */
def dotProduct3D(x1, y1, z1, x2, y2, z2):
    # sum of the product of each of the components
    return x1 * x2 + y1 * y2 + z1 * z2

# returns dot product of vector parameters
# parameters are the components of the two vectors (x1 is x component of first vector, x2 is x component of second vector, etc.) */
def dotProduct2D(x1, y1, x2, y2):
    # sum of the product of each of the components
    return x1 * x2 + y1 * y2

# examples
print("Cross Product: " + crossProduct(1, 2, 3, 2, -1, 1)) # Cross Product: (5, 5, -5)
print("Dot Product: " + str(dotProduct3D(1, 2, 3, 2, -1, 1))) # Dot Product: 3
print("Dot Product: " + str(dotProduct2D(1, 2, 2, -1))) # Dot Product: 0