import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.io.File;

public class Problem_1_Upsetris {

    public static void main(String[] args) {
        try {
            Scanner file = new Scanner(new File("C:\\Users\\Mike\\Desktop\\DATA10.txt"));
            while (file.hasNextLine()) {

                // 2D matrix representing the entire board
                ArrayList<ArrayList<String>> board = new ArrayList<ArrayList<String>>();

                String line = "";
                while (!line.contains("=")) { // until the bottom of the board
                    line = file.nextLine();
                    ArrayList<String> row = new ArrayList<String>(Arrays.asList(line.split(""))); // every character is an element in ArrayList
                    row.remove(0); // always blank element in beginning when splitting by "" so just remove it
                    board.add(row); // board list contains lists for elements that are every character of the board
                }
                
                int colLength = board.get(0).size(), rowLength = 0; // column and row length of the board

                // find the number of rows by testing how many lists are in the list of lists
                for (ArrayList<String> row : board) {
                    rowLength++;
                }

                ArrayList<ArrayList<String>> rotatedMatrix = new ArrayList<ArrayList<String>>();

                // populate rotated matrix to be the exact same size as the board matrix (empty elements though)
                for (ArrayList<String> row : board) {
                    ArrayList<String> blankRow = new ArrayList<String>(Arrays.asList(new String[colLength]));
                    rotatedMatrix.add(blankRow);
                }

                // flip board diagonally
                for (int r = 0; r < rowLength; r++) {
                    for (int c = 0; c < colLength; c++) {
                        // when switching positions diagonally, the two row positions being switched must add to the total row length
                        // and the same goes with the two column positions. So for example, if the row = 4 and column = 3 and the matrix
                        // has row length 10 and column length 7, the swapped position would have row = 6 and column = 4.
                        // in general, col2 = colLength - col1 and row2 = rowLength - row2
                        // so set each element at (r, c) in rotated matrix to (rowLength - r, colLength - c) from original board
                        // but accounting for array indexes counting from 0, so subtract 1 from rowLength and colLength
                        rotatedMatrix.get(r).set(c, board.get(rowLength - 1 - r).get(colLength - 1 - c));
                    }
                }

                // swap floor and ceiling
                ArrayList<String> ceil = rotatedMatrix.get(0);
                ArrayList<String> floor = rotatedMatrix.get(rowLength-1);
                rotatedMatrix.set(0, floor);
                rotatedMatrix.set(rowLength-1, ceil);

                // each element is number of zeros for that column
                ArrayList<Integer> listOfNumberOfOs = new ArrayList<Integer>();

                for (int c = 0; c < colLength; c++) { // for every column in rotated board
                    int numberOfOs = 0; // number of Os for this column
                    for (int r = 0; r < rowLength; r++) {
                        if (rotatedMatrix.get(r).get(c).equals("O")) {
                            numberOfOs++;
                        }
                    }
                    listOfNumberOfOs.add(numberOfOs);
                }

                for (int c = 1; c < colLength - 1; c++) { // for every column in rotated board
                    // replace bottom of column with Os (up to number of Os in column)
                    
                    for (int r = 0; r < rowLength - 1 - listOfNumberOfOs.get(c); r++) { // from top of column until Os need to be placed
                        rotatedMatrix.get(r).set(c, " ");
                    }
                    for (int r = rowLength - 1 - listOfNumberOfOs.get(c); r < rowLength - 1; r++) { // from where Os need to start being placed to fill the rest of the column until the bottom of the column (not including floor)
                        rotatedMatrix.get(r).set(c, "O");
                    }
                    
                    //for (int r = rowLength - 2; r > rowLength - 2 - listOfNumberOfOs.get(c); r--) { // start at bottom of board (not floor) and continue placing Os from bottom to top for the number of Os in the column
                    //    rotatedMatrix.get(r).set(c, "O");
                    //}
                    //for (int r = 0; r <= rowLength - 2 - listOfNumberOfOs.get(c); r++) { // start from top of column and place whitespace until the Os that were just placed are reached
                    //    rotatedMatrix.get(r).set(c, " ");
                    //}
                }

                // list of row numbers to be removed from the board list
                ArrayList<Integer> removes = new ArrayList<Integer>();

                for (int r = 0; r < rowLength-1; r++) { // for every row in board
                    boolean allOs = true; // represents if entire row is Os
                    for (int c = 1; c < colLength-1; c++) { // for every column in row
                        if (!rotatedMatrix.get(r).get(c).equals("O")) { // if this is NOT an O
                            allOs = false; // they're not all Os
                        }
                    }
                    if (allOs) { // if entire row of Os
                        removes.add(r); // this is a removable row
                    }
                }

                for (int remove : removes) { // for every row to be removed from board (full row of Os)
                    rotatedMatrix.remove(remove); // remove this row
                    
                    // create a blank row
                    ArrayList<String> blankRow = new ArrayList<String>();
                    blankRow.add("|");
                    for (int i = 1; i < colLength - 1; i++) blankRow.add(" ");
                    blankRow.add("|");
                    
                    rotatedMatrix.add(0, blankRow); // row was removed, so add a blank one to the top to keep the board the same dimensions
                }

                // print out the rotated matrix
                for (ArrayList<String> al : rotatedMatrix) {
                    for (String s : al) {
                        System.out.print(s);
                    }
                    System.out.println();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}